﻿var NUM_COLUMNS = 10;
var g_RowCount = 0;
var g_OffSet = 0;

var card_index;
var port_index;
var global_port_index;

var colWidth = new Array("55px","75px","50px","80px","80px","60px","60px","70px","75px","105px");


function AddRows(tableId, rowNum)
{
	var table = document.getElementById(tableId);
	for(var i = 0; i < rowNum; i++)
	{
		var row = table.insertRow(g_RowCount + 1);

		for(var j = 0; j < NUM_COLUMNS; j++)
		{
			var cell = row.insertCell(j);
		}
		
		g_RowCount++;
	}
}

function UpdateRowNum(tableId, dataLen)
{
	g_OffSet = g_RowCount;
	AddRows(tableId, (dataLen - 1));
}

function UpdateRowData(table, rowID, rowData)
{
	var row = rowID + g_OffSet;
	
	for(var i = 0; i < NUM_COLUMNS; i++)
	{
		var textData = "";
		var cell = table.rows[row].cells[i];
		cell.style.width = colWidth[i];
		
		if(i == 9)
		{
			cell.innerHTML = "";
			var el = document.createElement("img");
			el.width = "86";
			el.height = "13";
			el.align = "bottom";
			el.alt = "Output Bandwidth display";
			el.src = '../images/pb_' + rowData[i] + '.jpg';
			cell.appendChild(el);
		}
		else
		{
			if((i == 1) || (i == 6) || (i == 7))
			{
				textData = parseFloat(rowData[i]).toFixed(3);
			}
			else if((i == 3) || (i == 4))
			{
				textData = parseFloat(rowData[i]).toFixed(4);
			}
			else if(i == 5)
			{
				textData = rowData[i] + "%";
			}
			else
			{
				textData = rowData[i];
			}
			cell.innerHTML = textData;
		}
	}
}

function UpdateTableData(tableId, rfResp)
{
	var dataLen = rfResp.length;
	var MeasRow = new Array(NUM_COLUMNS);
	var table = document.getElementById(tableId);
	for(var i = 0;i < (dataLen - 1); i++)
	{
		MeasRow = rfResp[i];
		var rowData = MeasRow.split(",");
		UpdateRowData(table, (i + 1), rowData);
	}
}

function PaintMeasTable(MeasTable)
{
	var dataLen = MeasTable.length;//the end is row value, then dataLen is n+1
	UpdateRowNum("MeasRfTable",dataLen);
	UpdateTableData("MeasRfTable",MeasTable);
	return true;
}

var start_chn;
var init_row = true;
function GetMeasureRfOutpData()
{
	var xmlhttp = false;
	xmlhttp = getHTTPObject();
	
	if(init_row)
	{
		start_chn = global_port_index + "." + "1";
	}
	var params = "type=13&cmd=1&start_chn=" + start_chn;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var Response = xmlhttp.responseText;
			var rfResp = Response.slice(7, -8).split("&");
			var rfLen = rfResp.length;
			PaintMeasTable(rfResp);

			init_row = false;
			
			if(rfResp[rfLen - 1].indexOf("start_chn") != -1)
			{
				var cur_row_string = rfResp[rfLen - 1].split(",");
				start_chn = cur_row_string[1];
			}

			if(rfResp[rfLen - 1] == "end")
			{
				init_row = true;
				return true;
			}
			setTimeout("GetMeasureRfOutpData()", 5);
		}
	}
	xmlhttp.send(params);
}


/***** functions called on load of page *****/
window.onload = function()
{
	var args = getArgs();
	var nodeId = args["nodeId"];
	if(nodeId == null)
	{
		nodeId = parent.curTree.getSelectedNodes()[0].nId;
	}
	var str = nodeId.split("_");
	card_index = parseInt(str[1]);
	port_index = parseInt(str[2]);
	
	global_port_index = card_index + "/" + port_index;
	GetMeasureRfOutpData();
}

